/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.RetrieveInternalCodeTasklet;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdaterListener;
import java.util.List;

class HMCUpdateHandler
implements UpdaterListener {
    private static final String TRACE_MASKT = "XMCLHUHT";
    private static final String TRACE_MASKF = "XMCLHUHF";
    private static final String TRACE_MASKD = "XMCLHUHD";
    private ObjectId objectID;
    private RetrieveInternalCodeTasklet theRetrieveTasklet;
    private int activeUpdaterCount = 0;
    private boolean distributeUpdatesFlag = false;
    private int failingUpdaterCount = 0;
    private LocalizableText firstErrorMessage;

    HMCUpdateHandler(ObjectId objectID, RetrieveInternalCodeTasklet tasklet) {
        Trace.trace(TRACE_MASKT, "<> HMCUpdateHandler constructor");
        this.objectID = objectID;
        this.theRetrieveTasklet = tasklet;
    }

    void incrementUpdaterCount() {
        Trace.trace(TRACE_MASKT, "<> HMCUpdateHandler.incrementUpdaterCount()");
        ++this.activeUpdaterCount;
    }

    void changeProgressPanelStatus(String textBundleKey) {
        Trace.trace(TRACE_MASKT, "<> HMCUpdateHandler.changeProgressPanelStatus()");
        LocalizableText localizableText = new LocalizableText(BaseTextBundle.getBundleName(), textBundleKey);
    }

    private void startDistributionThread() {
        Trace.trace(TRACE_MASKT, "-> HMCUpdateHandler.startDistributionThread()");
        Runnable progRun = new Runnable(){

            public void run() {
                Trace.trace(HMCUpdateHandler.TRACE_MASKT, "-> HMCUpdateHandler.startDistributionThread.run()");
                Trace.trace(HMCUpdateHandler.TRACE_MASKT, "<- HMCUpdateHandler.startDistributionThread().run()");
            }
        };
        new Thread(progRun, "HMCUpdateHandlerDistribution").start();
        Trace.trace(TRACE_MASKT, "<- HMCUpdateHandler.startDistributionThread()");
    }

    public void operationCompleted(UpdaterEvent e) {
        List ucList;
        Trace.trace(TRACE_MASKT, "-> HMCUpdateHandler.operationCompleted()");
        Updater up = (Updater)e.getSource();
        int status = e.getCompletionStatus();
        if (2 == status && ++this.failingUpdaterCount == 1) {
            Trace.trace(TRACE_MASKD, " [operationCompleted()] Received unsuccessful completion status (objectID = " + this.objectID + ", count = " + Integer.toString(this.failingUpdaterCount) + ").");
            LocalizableText msgDetail = e.getDetailsMessage();
            this.firstErrorMessage = null != msgDetail ? msgDetail : e.getMessage();
            Trace.trace(TRACE_MASKD, " [operationCompleted()] The completion message is '" + this.firstErrorMessage + "'.");
        }
        if (!this.distributeUpdatesFlag && (ucList = e.getImportedUpdateCollections()).size() > 0) {
            this.distributeUpdatesFlag = true;
        }
        if (--this.activeUpdaterCount == 0 && this.distributeUpdatesFlag) {
            this.changeProgressPanelStatus("updates.retrvint.progress.hmc.distribute");
        }
        Trace.trace(TRACE_MASKT, "<- HMCUpdateHandler.operationCompleted()");
    }

    public void operationProgressing(UpdaterEvent e) {
        Trace.trace(TRACE_MASKT, "<> HMCUpdateHandler.operationProgressing()");
    }
}

